'use strict';

angular.module('genisis').service('comment', ['$window', 'user',
  'request',
  function ($window, $user, $request) {
    var _commentTypes = [{
      id: 1,
      name: 'operation',
      displayName: 'Operation'
    }, {
      id: 2,
      name: 'general',
      displayName: 'General'
    }];

    // this.validActionComments = function (commentType) {
    //   if (commentType === 1 && $user.genisis2Mgr()) {
    //     $window.alert(
    //       'This action is required to be general, ' +
    //       'automatically processing it as a general ' +
    //       'comment'
    //     );
    //   }
    // };
    this.validActionComments = function (commentType) {
      var ct = parseInt(commentType, 10);
      if (ct === 2 && $request.canChangeCommentType()) {
        var confirm2 = $window.confirm(
          'If you want this comment marked as General ' +
          'and seen by all, click OK.'
        );
        if (confirm2) {
          // If user presses OK
          return false;
        } else {
          // If user presses CANCEL
          return true;
        }
      } else {
        return false;
      }
    };

    this.initConfirm = function (commentType) {
      var ct = parseInt(commentType, 10);
      if (ct === 1 && $request.canChangeCommentType()) {
        var confirm1 = $window.confirm(
          'Comments associated with a status change' +
          ' cannot process as an Operation comment.' +
          ' To continue and process the comment' +
          ' as a General comment click OK if not click Cancel.'
        );
        if (confirm1) {
          // If user presses OK
          return false;
        } else {
          // If user presses CANCEL
          return true;
        }
      } else {
        return false;
      }
    };

    this.toNameForCommentType = function (id) {
      if (!id) {
        return null;
      }

      var commentType = this.find(id);
      return (commentType) ? commentType.name : null;
    };

    this.findIdByName = function (name) {

      if (!name) {
        return null;
      }
      var id = null;
      //make sure it's always an integer
      angular.forEach(_commentTypes, function (commentType) {
        if (commentType.name === name) {
          id = commentType.id;
        }
      });

      return id;
    };

    this.getCommentTypes = function () {
      return _commentTypes;
    };

    this.getCommentTypeByUser = function (user) {
      // If Requester default it to general
      // If DDM default to general
      // If DSM default it to operation
      // Else defaut it general

      if (user.requester() || user.genisis2Mgr() || user.Administrator()) {
        return 2;
      } else if (user.vinciMgr()) {
        return 1;
      } else {
        return 1;
      }
    };

    this.getCommentNameById = function (id) {
      var type_id = parseInt(id, 10);
      var type_name = null;
      angular.forEach(_commentTypes, function (commentType) {
        if (commentType.id === type_id) {
          type_name = commentType.name;
        }
      });
      return type_name;
    };


  }
]);